// RadIntro.js | Radnen 2008 //
// Refer to RadLib.js to see an example //

function IntroBlock()
{
	this.actions = [];
	this.skipKey = KEY_ESCAPE;
	this.preRender = function(){};
}

IntroBlock.prototype.play = function()
{
	Key = this.skipKey;
	function Clear()
	{
		return IsKeyPressed(Key);
	}
	
	for (var i = 0; i < this.actions.length; ++i)
	{
		var time = GetTime();
		var act = this.actions[i];
		if (act.msecs != undefined)
		{
			while(time + act.msecs > GetTime() && !Clear())
			{
				this.preRender();
				act.action();
				FlipScreen();
			}
		}
		else this.preRender(), act.action();
	}
}

IntroBlock.prototype.addAction = function(action, playLength)
{
	this.actions.push({action: action, msecs: playLength});
}